/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public abstract class NotificationAbstractTasklet
extends HwmcaPanelTasklet
implements NotificationErrorIds,
NotificationConstants {
    private static final String TRACE_MASKT = "XNTYTSKT";
    private static final String TRACE_MASKF = "XNTYTSKF";
    private static final String TRACE_MASKD = "XNTYTSKD";
    protected static final String BOUNCE_COMMAND = "BounceCommand";
    protected static final String BOUNCE_BEAN_NAME = "BounceBeanName";
    protected int mode;
    protected short errorId = 0;

    public void logException(Throwable throwable) {
        new FrameworkLog(NotificationErrorIds._logInfo, this.errorId, throwable).log();
    }

    public abstract void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;

    protected void serviceDisposed(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> servicing a disposed request");
        String source = (String)request.getData("CommandSource");
        if (source == null) {
            Trace.trace(TRACE_MASKD, "terminating normally");
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKD, "disposing a specific source");
            response.dispose(source);
        }
        this.destroy();
    }

    protected void unknownCommand(PanelTaskletResponse response, String command) throws TaskletException {
        Trace.trace(TRACE_MASKF, "Unknown command!: " + command);
        new FrameworkLog(NotificationErrorIds._logInfo, -32739, new IllegalStateException("Unknown command: " + command)).log();
        response.error(new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.error.unknowncommand", new String[]{command}), command);
    }

    protected void duplicateMessage(String duplicateName) throws TaskletException {
        Trace.trace(TRACE_MASKF, "duplicate name: " + duplicateName);
        this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.task.name"), new MessageText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.error.dupname", new String[]{duplicateName}), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
    }

    protected boolean okToDelete(String item) throws TaskletException {
        Trace.trace(TRACE_MASKF, "ok to delete: " + item + "?");
        LocalizableText ans = null;
        ans = this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.task.name"), new MessageText("com.ibm.hwmca.base.ntfy.NotificationMessageRes", "ntfy.question.delete", new String[]{item}), MsgType.QUESTION_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.yes"), new LocalizableText("com/ibm/hwmca/fw/res/common", "button.no")});
        return ans != null && ans.equals(new LocalizableText("com/ibm/hwmca/fw/res/common", "button.yes"));
    }

    protected void serviceBounce(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceBounce");
        response.update((String)request.getData(BOUNCE_BEAN_NAME), request.getData(BOUNCE_COMMAND));
    }

    protected void bounceUpdate(String beanName, Object bounceData) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> bounceUpdate: " + beanName + ", " + bounceData);
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName());
        request.setData("CommandName", BOUNCE_COMMAND);
        request.setData(BOUNCE_COMMAND, bounceData);
        request.setData(BOUNCE_BEAN_NAME, beanName);
        this.postRequest(beanName, request);
    }
}

